;
;								EJEMPLO 9
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;La interrupcin del TMR0.
;
;Se trata de comprobar la interrupcin provocada por el TMR0. El programa
;lee el estado de los interruptores conectados a RA0 y RA1 para reflejarlo en
;los leds conectados a RB0 y RB1 respectivamente. Al mismo tiempo el TMR0
;genera una interrupcin cada 0.01 seg. (10 mS) que se repetir 50 veces con objeto 
;de hacer intermitencia de 500 mS sobre el led conectado a RB7.

	
		List	p=16F876A	;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos

;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdig y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

		__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC

Contador		equ	0x020			;Variable para la temporizacin
              
				org	0x00			;Vector de RESET
				goto	Inicio
				org	0x04			;Vector de interrupcin
				goto	Interrupcion
				org	0x05

Interrupcion   	bcf		INTCON,T0IF	;Repone flag del TMR0
				decfsz 	Contador,F	;Decrementa el contador. Ha habido 50 interrupciones ??
           		goto 	Seguir		;No, no han pasado los 500 mS
Con_si_0   		movlw 	.50
           		movwf 	Contador   	;Repone el contador nuevamente para contar 50 interrupciones
           		movlw	b'10000000'
				xorwf	PORTB,F		;RB7 cambia de estado
Seguir    		movlw 	~.39
           		movwf 	TMR0      	;Repone el TMR0 con 39
           		retfie				;Retorno de interrupcin

Inicio	       	clrf 	PORTB		;Borra los latch de salida
				bsf		STATUS,RP0	;Selecciona banco 1
				clrf	TRISB		;Puerta B se configura como salida
				movlw	0x06
				movwf	ADCON1		;Puerta A digital
				movlw	b'00111111'
				movwf	TRISA		;Puerta A se configura como entrada
				movlw	b'00000111'
				movwf	OPTION_REG	;Preescaler de 256 para el TMR0		
				bcf		STATUS,RP0	;Selecciona banco 0			                                                                         

;El TMR0 se carga con 39. Con un preescaler de 256 y a una frecuencia de 4MHz se obtiene una interrupcin
;cada 10mS. Se habilita la interrupcin del TMR0.

				movlw	~.39
				movwf	TMR0		;Carga el TMR0 con 39
				movlw	.50
				movwf	Contador	;N de veces a repetir la interrupcin
				movlw	b'10100000'
				movwf	INTCON		;Activa la interrupcin del TMR0

;Este es el cuerpo principal del programa. Consiste en leer constantemente el estado de RA0 y RA1 para visualizar
;sobre RB0 y RB1 sin que cambie el estado actual de RB7

Loop			btfsc 	PORTA,0     ;Testea el estado de RA0
           		goto 	RA0_ES_1
           		bcf 	PORTB,0		;Desactiva RB0
           		goto 	TEST_RB1
RA0_ES_1   		bsf 	PORTB,0		;Activa RB0
TEST_RB1   		btfsc 	PORTA,1     ;Testea el estado de RA1
           		goto 	RA1_ES_1
           		bcf 	PORTB,1		;Desactiva RB1
           		goto 	Loop
RA1_ES_1  	 	bsf 	PORTB,1		;Activa RB1
				goto 	Loop

				end					;Fin del programa fuente
